<?php
/*
Plugin Name: WP Auto Tube Map
Plugin URI: https://marketinginunderwear.com/
Description: Add an automatically updating video sitemap to your site and get free traffic.
Version: 1.0.1
Author: Mark Hess
Author URI: https://marketinginunderwear.com/
*/


add_action ('admin_menu', 'video_sitemap_generate_page');
add_action( 'save_post', 'save_sitemap_on_save_post');

function video_sitemap_generate_page () {
	
    	add_options_page (__('WP Auto Tube Map'), __('WP Auto Tube Map'),
        	'manage_options', 'auto-tube-map', 'video_sitemap_generate');
}


	function save_sitemap_on_save_post( $post_id ) {

		$post_type = get_post_type( $post_id );

		if ( $post_type == 'page' || $post_type == 'post' )
		{
			
		
$d="";

$v="";

$y="";


if(get_option('dailymotion_video')==1) { $d=1;}


if(get_option('vimeo_video')==1) { $v=1;}


if(get_option('youtube_video')==1) { $y=1;}



if($d!="" || $v!="" || $y!="") {
  video_sitemap_auto_generate($d,$v,$y);
}
			}
	}

	
	function IsVideoSitemapWritable($filename) {
		
		
		if(!is_writable($filename)) { 
			
			if(!@chmod($filename, 0666)) {
				$pathtofilename = dirname($filename); 
				
				if(!is_writable($pathtofilename)) {
					
					if(!@chmod($pathtoffilename, 0666)) {
						
						return false;
					}
				}
			}
		}
		
		return true;
	}



function video_sitemap_generate () {


if (isset($_POST ['save']) && (!empty($_POST['dailymotion']) || !empty($_POST['vimeo']) || !empty($_POST['youtube']))) 
{
      
	if (isset($_POST['dailymotion'])) { add_option( 'dailymotion_video', '1', '', 'yes' ); }
	else { delete_option( 'dailymotion_video'); }
    
    if (isset($_POST['vimeo'])) { add_option( 'vimeo_video', '1', '', 'yes' ); }
	else { delete_option( 'vimeo_video'); }
	
	if (isset($_POST['youtube'])){ add_option( 'youtube_video', '1', '', 'yes' ); }
	else { delete_option( 'youtube_video'); }

}
else if (isset($_POST ['save']) && empty($_POST['dailymotion']) && empty($_POST['vimeo']) && empty($_POST['youtube'])) 
{

echo "<script>alert('Please select atleast one video service');return false;</script>"; 
}



if (isset($_POST ['generate']) && ((get_option('dailymotion_video')==1) || (get_option('vimeo_video')==1) || (get_option('youtube_video')==1)))
{
	
$d="";

$v="";

$y="";


if(get_option('dailymotion_video')==1) { $d=1;}


if(get_option('vimeo_video')==1) { $v=1;}


if(get_option('youtube_video')==1) { $y=1;}


$st = video_sitemap_loop ($d,$v,$y);
		if (!$st) {
echo '';	
exit();
}

?>

<div class="wrap">
<div style="float:right; margin:10px">
</div>
<h1>Success! You're Good To Go...</h1>
<?php $sitemapurl =  get_site_url()."/video-sitemap.xml"; ?>
	<h2><b><a target="_blank" href="<?php echo $sitemapurl; ?>">CLICK HERE TO VIEW YOUR RAW SEO VIDEO SITEMAP</a></b></h2>
	<p></p>
  <div style="border:1px solid #dfdfdf;"></div>
  <h3>Step 3: Submit Your SEO Video Sitemap To Google and Bing:</h3> 
	<h2><a href="https://search.google.com/search-console/sitemaps" target="_blank">CLICK HERE TO SUBMIT YOUR SEO VIDEO SITEMAP TO GOOGLE</a> <br></br>
<a href="https://www.bing.com/webmaster/home/dashboard/" target="_blank">CLICK HERE TO SUBMIT YOUR SEO VIDEO SITEMAP TO BING</a> </h2>

	
<?php 
} 
else
{ 

if (isset($_POST ['generate']) && ((get_option('dailymotion_video')!=1) || (get_option('vimeo_video')!=1) || (get_option('youtube_video')!=1)))
{
echo "<script>alert('Please select atleast one video service from the services listed above');return false;</script>"; 
}
?>

<div class="wrap">
	<h2>WP Auto Tube Map Configuration</h2></br>
<h3>Step 1: Main Plugin Settings:</h3> 
  
                    
  <form id="options_form" method="post" action="" >
	  <label for="dailymotion">Activate Plugin:</label>
	  <input type="checkbox" id="youtube" name="youtube" value="1" <?php if(get_option('youtube_video')!=0){ ?>  checked="checked" <?php }?>/></br>
    
    <label for="vimeo">Automatically Discover New YouTube and Vimeo Videos On Your Site:</label>
	<input type="checkbox" id="vimeo" name="vimeo" value="1" <?php if(get_option('vimeo_video')!=0){ ?> checked="checked" <?php }?>/></br>

	 <label for="youtube">Automatically Update Your Video Sitemap:</label>
	<input type="checkbox" id="dailymotion" name="dailymotion" value="1" <?php if(get_option('dailymotion_video')!=0){ ?>  checked="checked" <?php }?> /></br>
   
	

    <div class="submit">
      <input type="submit" name="save" id="sb_submit" value="Save Main Settings" />
    </div>
  </form>
  <p></p>
  <div style="border:1px solid #dfdfdf;"></div>
  <h3>Step 2: Automatically Generate Your SEO Video Sitemap:</h3> 
  <p>
   <form id="options_form" method="post" action="" >
    <input type="submit" name="generate" id="gn_submit" value="Click Here To Generate Your Video Sitemap" />
    </div>
  </form>
  </p>
</div>
<?php	}
}



function video_sitemap_loop ($dailymtn,$vimeo,$ytube) {
	global $wpdb;
	
    $condition="(";
	if ($dailymtn!="") { $condition.=" post_content LIKE '%dailymotion.com%' ||"; }
	if ($vimeo!="")	{ $condition.=" post_content LIKE '%vimeo.com%' ||";  }
	if ($ytube!="")	{ $condition.=" post_content LIKE '%youtube.com%' ||"; }
	$condition=substr($condition, 0, -2);	
	$condition.=")";
	
	
	$posts = $wpdb->get_results ("SELECT id, post_title, post_content, post_date_gmt, post_excerpt 
							FROM $wpdb->posts 
							WHERE post_status = 'publish' 
							AND (post_type = 'post' OR post_type = 'page')
							AND $condition 
							ORDER BY post_date DESC");
      
	  
	if (empty ($posts)) {
	
	echo "Sitemap has not been genrated because No Videos Found!";
		return false;

	} else {
         
		$xml  = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";       		     	
	    $xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">' . "\n";	
		
		
		
                       foreach ($posts as $post) {
					   $a=0;
			if (preg_match_all ("/http:\/\/www.dailymotion.com\/embed\/video\/([a-z0-9\-]*)/", 
				$post->post_content, $matches, PREG_SET_ORDER)) {
                    $excerpt = ($post->post_excerpt != "") ? $post->post_excerpt : $post->post_title ; 
                    $permalink = video_EscapeXMLEntities(get_permalink($post->id)); 
					$publish_date=date (DATE_W3C, strtotime ($post->post_date_gmt));
					
					
                foreach ($matches as $match) {
						$id = $match [1];
						
						
						if ($id == '') $id = $match [2];
						if ($id == '') $id = $match [3];
						
						$fixa =  $a++==0?'':' [Video '. $a .'] ';
						
					$dynamic_data='';	
	                $dynamic_data=dailymotion_data($id);
					$xml .= "\n <url>\n";
					$xml .= " <loc>$permalink</loc>\n";
					$xml .= " <video:video>\n";
					$xml .= "  <video:player_loc allow_embed=\"yes\" autoplay=\"autoplay=1\">http://www.dailymotion.com/embed/video/$id</video:player_loc>\n";
					
					$xml .= "  <video:title>" . htmlspecialchars($post->post_title) . $fixa . "</video:title>\n";
                    
					$xml .= "  <video:description>" . $fixa . htmlspecialchars($excerpt) . "</video:description>\n";	
                     $xml .= "  <video:duration>" . htmlspecialchars($dynamic_data['duration']) . "</video:duration>\n";					
                 $xml .= " <video:thumbnail_loc>". htmlspecialchars($dynamic_data['thumbnail_loc']) ."</video:thumbnail_loc>\n";
                     
                     $xml .= "  <video:publication_date>" . $publish_date . "</video:publication_date>\n";
					$xml .= " </video:video>\n </url>";
				}
			}
		}

		
		
		
		foreach ($posts as $post) {
		$b=0;
			if (preg_match_all ("/http:\/\/player.vimeo.com\/video\/([a-z0-9\-]*)/", 
				$post->post_content, $matches, PREG_SET_ORDER)) {
                    $excerpt = ($post->post_excerpt != "") ? $post->post_excerpt : $post->post_title ; 
                    $permalink = video_EscapeXMLEntities(get_permalink($post->id)); 
					$publish_date=date (DATE_W3C, strtotime ($post->post_date_gmt));
                    foreach ($matches as $match) {
						$id = $match [1];
						
						$fixb =  $b++==0?'':' [Video '. $b .'] ';
						
						if ($id == '') $id = $match [2];
						if ($id == '') $id = $match [3];
					$dynamic_data='';	
	                $dynamic_data=vimeo_data($id);
					$xml .= "\n <url>\n";
					$xml .= " <loc>$permalink</loc>\n";
					$xml .= " <video:video>\n";
					$xml .= "  <video:player_loc allow_embed=\"yes\" autoplay=\"autoplay=1\">http://player.vimeo.com/video/$id</video:player_loc>\n";
					
					$xml .= "  <video:title>" . htmlspecialchars($post->post_title) . $fixb . "</video:title>\n";
                    
					$xml .= "  <video:description>" . $fixb . htmlspecialchars($excerpt) . "</video:description>\n";	

					 $xml .= "  <video:duration>" . htmlspecialchars($dynamic_data['duration']) . "</video:duration>\n";					
                 $xml .= " <video:thumbnail_loc>". htmlspecialchars($dynamic_data['thumbnail_loc']) ."</video:thumbnail_loc>\n";
                     
                     $xml .= "  <video:publication_date>" . $publish_date . "</video:publication_date>\n";
					$xml .= " </video:video>\n </url>";
				}
			}
		}
		
				
		
		
		
		        $videos = array();
    
        foreach ($posts as $post) {
            $c = 0;
            if (preg_match_all ("/youtube.com\/(v\/|watch\?v=|embed\/)([a-zA-Z0-9\-_]*)/", $post->post_content, $matches, PREG_SET_ORDER)) {

                    $excerpt = ($post->post_excerpt != "") ? $post->post_excerpt : $post->post_title ; 
                    $permalink = video_EscapeXMLEntities(get_permalink($post->id)); 

                foreach ($matches as $match) {
                                    
                        $id = $match [2];
                        $fixc =  $c++==0?'':' [Video '. $c .'] ';
                        
                        if (in_array($id, $videos))
                            continue;
                            
                        array_push($videos, $id);
                        
                        $xml .= "\n <url>\n";
                        $xml .= " <loc>$permalink</loc>\n";
                        $xml .= " <video:video>\n";
                        $xml .= "  <video:player_loc allow_embed=\"yes\" autoplay=\"autoplay=1\">http://www.youtube.com/v/$id</video:player_loc>\n";
                       
                        $xml .= "  <video:title>" . htmlspecialchars($post->post_title) . $fixc . "</video:title>\n";
                        $xml .= "  <video:description>" . $fixc . htmlspecialchars($excerpt) . "</video:description>\n";
    
                        $xml .= "  <video:duration>".youtube_duration ($id)."</video:duration>\n";
                         
  					    $xml .= "  <video:thumbnail_loc>http://i.ytimg.com/vi/$id/hqdefault.jpg</video:thumbnail_loc>\n";  

                    $xml .= "  <video:publication_date>".date (DATE_W3C, strtotime ($post->post_date_gmt))."</video:publication_date>\n";
    
         

                    $xml .= " </video:video>\n </url>";
                }
            }
        }
		
		$xml .= "\n</urlset>";
	}

	
	$video_sitemap_url = $_SERVER['DOCUMENT_ROOT'].'/video-sitemap.xml'; 
	
	
	if (IsVideoSitemapWritable($video_sitemap_url)) 
	{    
	    
		if (file_put_contents ($video_sitemap_url, $xml)) 
		{
			return true;
		}
	} 
	
echo '<br /><div class="wrap"><h2>Error Writing XML File</h2><p>The sitemap has been generated successfully, but the plugin was unable to save the xml file in your root WordPress folder <strong>' . $_SERVER["DOCUMENT_ROOT"] . '</strong> probably because the file is write-protected <a href="http://codex.wordpress.org/Changing_File_Permissions" target="_blank">permissions writing </a>.</p><p> You can manually copy and paste the following text into a file and save it as video-sitemap.xml in your root WordPress folder. </p><br /><textarea rows="30" cols="150" style="font-family:verdana; font-size:11px;color:#666;background-color:#f9f9f9;padding:5px;margin:5px">' . $xml . '</textarea></div>';	
	exit();
}


	function dailymotion_data( $video_id ) {
    
	 
    $api_url = "https://api.dailymotion.com/video/$video_id?fields=title,duration,description,thumbnail_360_url";
  
	$request = wp_remote_get( $api_url );
	print_r($request);
		$data = json_decode( $request['body'] );
        
        $title= $data->title;
        $duration = $data->duration;
        $description= $data->description;
		$thumbnail_loc= $data->thumbnail_360_url;
		return array(
				'title' => $title,
				'duration' => $duration,
				'description' => $description,
				'thumbnail_loc' => $thumbnail_loc,
				);
	}
	
	
function vimeo_data( $video_id ) {
    
    $api_url ="http://vimeo.com/api/v2/video/$video_id.json";
	$request = wp_remote_get( $api_url );
	
	$vim_data = json_decode( $request['body'] );
        
		
		$data=$vim_data[0];
        $title= $data->title;
        $duration = $data->duration;
        $description= $data->description;
		$thumbnail_loc= $data->thumbnail_large;
        return array(
				'title' => $title,
				'duration' => $duration,
				'description' => $description,
				'thumbnail_loc' => $thumbnail_loc,
				);
	}	
	
	
	function youtube_duration ($id) {
    try {
        $ch = curl_init ();
        curl_setopt ($ch, CURLOPT_URL, "http://gdata.youtube.com/feeds/api/videos/$id");
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        $data = curl_exec ($ch);
        curl_close ($ch);

        preg_match ("/duration=['\"]([0-9]*)['\"]/", $data, $match);
        return $match [1];

    } catch (Exception $e) {
        
        return '0';
    }
}


function video_EscapeXMLEntities($xml) {
    return str_replace(array('&', '<', '>', '\'', '"'), array('&amp;', '&lt;', '&gt;', '&apos;', '&quot;'), $xml);
}


function prefix_on_deactivate()
 {
	delete_option( 'dailymotion_video'); 
    delete_option( 'vimeo_video'); 
    delete_option( 'youtube_video');
}


function video_sitemap_auto_generate($dailymtn,$vimeo,$ytube) {
	global $wpdb;
	
    $condition="(";
	if ($dailymtn!="") { $condition.=" post_content LIKE '%dailymotion.com%' ||"; }
	if ($vimeo!="")	{ $condition.=" post_content LIKE '%vimeo.com%' ||";  }
	if ($ytube!="")	{ $condition.=" post_content LIKE '%youtube.com%' ||"; }
	$condition=substr($condition, 0, -2);	
	$condition.=")";
	
	
	$posts = $wpdb->get_results ("SELECT id, post_title, post_content, post_date_gmt, post_excerpt 
							FROM $wpdb->posts 
							WHERE post_status = 'publish' 
							AND (post_type = 'post' OR post_type = 'page')
							AND $condition 
							ORDER BY post_date DESC");
      
	  
	if (!empty ($posts)) 
	{
         
		$xml  = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";       		     	
	    $xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">' . "\n";	
		
		
		
                       foreach ($posts as $post) {
					   $a=0;
			if (preg_match_all ("/http:\/\/www.dailymotion.com\/embed\/video\/([a-z0-9\-]*)/", 
				$post->post_content, $matches, PREG_SET_ORDER)) {
                    $excerpt = ($post->post_excerpt != "") ? $post->post_excerpt : $post->post_title ; 
                    $permalink = video_EscapeXMLEntities(get_permalink($post->id)); 
					$publish_date=date (DATE_W3C, strtotime ($post->post_date_gmt));
					
					
                foreach ($matches as $match) {
						$id = $match [1];
						
						
						if ($id == '') $id = $match [2];
						if ($id == '') $id = $match [3];
						
						$fixa =  $a++==0?'':' [Video '. $a .'] ';
						
					$dynamic_data='';	
	                $dynamic_data=dailymotion_data($id);
					$xml .= "\n <url>\n";
					$xml .= " <loc>$permalink</loc>\n";
					$xml .= " <video:video>\n";
					$xml .= "  <video:player_loc allow_embed=\"yes\" autoplay=\"autoplay=1\">http://www.dailymotion.com/embed/video/$id</video:player_loc>\n";
					
					$xml .= "  <video:title>" . htmlspecialchars($post->post_title) . $fixa . "</video:title>\n";
                    
					$xml .= "  <video:description>" . $fixa . htmlspecialchars($excerpt) . "</video:description>\n";	
                     $xml .= "  <video:duration>" . htmlspecialchars($dynamic_data['duration']) . "</video:duration>\n";					
                 $xml .= " <video:thumbnail_loc>". htmlspecialchars($dynamic_data['thumbnail_loc']) ."</video:thumbnail_loc>\n";
                     
                     $xml .= "  <video:publication_date>" . $publish_date . "</video:publication_date>\n";
					$xml .= " </video:video>\n </url>";
				}
			}
		}

		
		
		
		foreach ($posts as $post) {
		$b=0;
			if (preg_match_all ("/http:\/\/player.vimeo.com\/video\/([a-z0-9\-]*)/", 
				$post->post_content, $matches, PREG_SET_ORDER)) {
                    $excerpt = ($post->post_excerpt != "") ? $post->post_excerpt : $post->post_title ; 
                    $permalink = video_EscapeXMLEntities(get_permalink($post->id)); 
					$publish_date=date (DATE_W3C, strtotime ($post->post_date_gmt));
                    foreach ($matches as $match) {
						$id = $match [1];
						
						$fixb =  $b++==0?'':' [Video '. $b .'] ';
						
						if ($id == '') $id = $match [2];
						if ($id == '') $id = $match [3];
					$dynamic_data='';	
	                $dynamic_data=vimeo_data($id);
					$xml .= "\n <url>\n";
					$xml .= " <loc>$permalink</loc>\n";
					$xml .= " <video:video>\n";
					$xml .= "  <video:player_loc allow_embed=\"yes\" autoplay=\"autoplay=1\">http://player.vimeo.com/video/$id</video:player_loc>\n";
					
					$xml .= "  <video:title>" . htmlspecialchars($post->post_title) . $fixb . "</video:title>\n";
                    
					$xml .= "  <video:description>" . $fixb . htmlspecialchars($excerpt) . "</video:description>\n";	

					 $xml .= "  <video:duration>" . htmlspecialchars($dynamic_data['duration']) . "</video:duration>\n";					
                 $xml .= " <video:thumbnail_loc>". htmlspecialchars($dynamic_data['thumbnail_loc']) ."</video:thumbnail_loc>\n";
                     
                     $xml .= "  <video:publication_date>" . $publish_date . "</video:publication_date>\n";
					$xml .= " </video:video>\n </url>";
				}
			}
		}
		
				
		
		
		
		        $videos = array();
    
        foreach ($posts as $post) {
            $c = 0;
            if (preg_match_all ("/youtube.com\/(v\/|watch\?v=|embed\/)([a-zA-Z0-9\-_]*)/", $post->post_content, $matches, PREG_SET_ORDER)) {

                    $excerpt = ($post->post_excerpt != "") ? $post->post_excerpt : $post->post_title ; 
                    $permalink = video_EscapeXMLEntities(get_permalink($post->id)); 

                foreach ($matches as $match) {
                                    
                        $id = $match [2];
                        $fixc =  $c++==0?'':' [Video '. $c .'] ';
                        
                        if (in_array($id, $videos))
                            continue;
                            
                        array_push($videos, $id);
                        
                        $xml .= "\n <url>\n";
                        $xml .= " <loc>$permalink</loc>\n";
                        $xml .= " <video:video>\n";
                        $xml .= "  <video:player_loc allow_embed=\"yes\" autoplay=\"autoplay=1\">http://www.youtube.com/v/$id</video:player_loc>\n";
                       
                        $xml .= "  <video:title>" . htmlspecialchars($post->post_title) . $fixc . "</video:title>\n";
                        $xml .= "  <video:description>" . $fixc . htmlspecialchars($excerpt) . "</video:description>\n";
    
                        $xml .= "  <video:duration>".youtube_duration ($id)."</video:duration>\n";
                         
  					    $xml .= "  <video:thumbnail_loc>http://i.ytimg.com/vi/$id/hqdefault.jpg</video:thumbnail_loc>\n";  

                    $xml .= "  <video:publication_date>".date (DATE_W3C, strtotime ($post->post_date_gmt))."</video:publication_date>\n";
    
         

                    $xml .= " </video:video>\n </url>";
                }
            }
        }
		
		$xml .= "\n</urlset>";
	}

	
	$video_sitemap_url = $_SERVER['DOCUMENT_ROOT'].'/video-sitemap.xml'; 
	
	
	if (IsVideoSitemapWritable($video_sitemap_url)) 
	{    
	    
		if (file_put_contents ($video_sitemap_url, $xml)) 
		{
			return true;
		}
	} 

}


register_deactivation_hook(__FILE__, 'prefix_on_deactivate');
?>